function gen_output(vDp_old, vDp, err_old, err, output)

LL='L';
TT='T';
LT='T';

LE = length(vDp);
fid = fopen(output,'a');
fprintf(fid,'--- output from gen_output --- \n');

if (LE == 5)
    t2   = vDp_old(5);
    t1   = vDp_old(4);
    beta = (vDp_old(3));
    
    tmean_old = (((t2./t1).^beta) .* (-t1 + (exp(t1./t2)) .* ((t1./t2).^beta) .* (t1 + beta.*t2)...
	.*igamma(1 - beta, t1./t2)))./(exp(t1./t2).*(beta*igamma(-beta, t1./t2)));

    t2   = vDp(5);
    t1   = vDp(4);
    beta = (vDp(3));
    
    tmean = (((t2./t1).^beta) .* (-t1 + (exp(t1./t2)) .* ((t1./t2).^beta) .* (t1 + beta.*t2)...
	.*igamma(1 - beta, t1./t2)))./(exp(t1./t2).*(beta*igamma(-beta, t1./t2)));
       
    fprintf(fid,'v    (initial) : %14.7e [%s/%s]   \n',vDp_old(1), LL, TT);
    fprintf(fid,'D    (initial) : %14.7e [%s^2/%s] \n',vDp_old(2) , LL, TT);
    fprintf(fid,'Beta (initial) : %14.7e           \n',vDp_old(3) );
    fprintf(fid,'t1   (initial) : %14.7e [%s]      \n',vDp_old(4), LT );
    fprintf(fid,'t2   (initial) : %14.7e [%s]      \n',vDp_old(5), LT );
    fprintf(fid,'tmean(initial) : %14.7e [%s]      \n',tmean_old, TT );
    fprintf(fid,'error(initial) : %14.7e           \n', err_old );
    fprintf(fid,'v    (final  ) : %14.7e [%s/%s]   \n',vDp(1), LL, TT);
    fprintf(fid,'D    (final  ) : %14.7e [%s^2/%s] \n',vDp(2) , LL, TT);
    fprintf(fid,'Beta (final  ) : %14.7e           \n',vDp(3) );
    fprintf(fid,'t1   (final  ) : %14.7e [%s]      \n',vDp(4), LT );
    fprintf(fid,'t2   (final  ) : %14.7e [%s]      \n',vDp(5), LT );
    fprintf(fid,'tmean(final  ) : %14.7e [%s]      \n',tmean, TT );
    fprintf(fid,'error(final  ) : %14.7e           \n', err );
end

fclose(fid);
